/*
 * Decompiled with CFR 0.152.
 */
package djbo.hlpt;

import djbo.hlpt.CubicBezCurve;
import java.awt.geom.Point2D;

abstract class Curve {
    final float a;
    final float b;

    private Curve(float f, float f2, float f3) {
        this.a = f;
        this.b = f2;
    }

    abstract float a(float var1);

    static Curve a(int n, float f, float f2, float f3) {
        if (n == 1) {
            return Curve.b(f, f2, f3);
        }
        if (n == 2) {
            return Curve.c(f, f2, f3);
        }
        if (n == 3) {
            return Curve.d(f, f2, f3);
        }
        if (n == 5) {
            return Curve.e(f, f2, f3);
        }
        if (n == 4) {
            return Curve.f(f, f2, f3);
        }
        return Curve.a(f, f2, f3);
    }

    static Curve a(float f, float f2, float f3) {
        return new Linear(f, f2, f3);
    }

    static Curve b(float f, float f2, float f3) {
        return new RoundConcave(f, f2, f3);
    }

    static Curve c(float f, float f2, float f3) {
        return new RoundConvex(f, f2, f3);
    }

    static Curve d(float f, float f2, float f3) {
        double d = (double)f * 0.75;
        Point2D.Double double_ = new Point2D.Double(0.0, f2);
        Point2D.Double double_2 = new Point2D.Double(d, f2);
        Point2D.Double double_3 = new Point2D.Double(f, f3);
        Point2D.Double double_4 = new Point2D.Double((double)f - d, f3);
        CubicBezCurve cubicBezCurve = new CubicBezCurve(double_, double_2, double_3, double_4);
        return new Bezier(new CubicBezCurve[]{cubicBezCurve});
    }

    static Curve e(float f, float f2, float f3) {
        return new FlatZero(f, f2, f3);
    }

    static Curve f(float f, float f2, float f3) {
        return new LinearStepped(f, f2, f3);
    }

    private static final class Bezier
    extends Curve {
        private final CubicBezCurve[] c;

        private Bezier(CubicBezCurve[] cubicBezCurveArray) {
            super(-1.0f, -1.0f, -1.0f);
            this.c = cubicBezCurveArray;
        }

        final float a(float f) {
            CubicBezCurve cubicBezCurve = null;
            double d = Double.MAX_VALUE;
            for (int i = 0; i < this.c.length; ++i) {
                double d2;
                CubicBezCurve cubicBezCurve2;
                CubicBezCurve cubicBezCurve3 = this.c[i];
                if (cubicBezCurve2.a.getX() <= cubicBezCurve3.b.getX() && cubicBezCurve3.a.getX() <= (double)f && cubicBezCurve3.b.getX() >= (double)f || cubicBezCurve3.b.getX() <= cubicBezCurve3.a.getX() && cubicBezCurve3.b.getX() <= (double)f && cubicBezCurve3.a.getX() >= (double)f) {
                    cubicBezCurve = cubicBezCurve3;
                    break;
                }
                double d3 = Math.min(Math.abs(cubicBezCurve3.a.getX() - (double)f), Math.abs(cubicBezCurve3.b.getX() - (double)f));
                if (!(d2 < d)) continue;
                cubicBezCurve = cubicBezCurve3;
                d = d3;
            }
            return (float)cubicBezCurve.a(f);
        }
    }

    private static final class RoundConvex
    extends Curve {
        private final float c;
        private final float d;
        private final boolean e;
        private final float f;
        private final float g;

        private RoundConvex(float f, float f2, float f3) {
            super(f, f2, f3);
            this.c = f * f;
            this.d = Math.abs(f2 - f3) / f;
            this.e = f3 > f2;
            this.g = Math.max(f3, f2);
            this.f = this.e ? f2 : f3;
        }

        final float a(float f) {
            float f2 = (float)Math.sqrt(this.c - f * f);
            f2 = this.g - f2;
            return f2 * this.d + this.f;
        }
    }

    private static final class RoundConcave
    extends Curve {
        private final float c;
        private final float d;
        private final boolean e;
        private final float f;

        private RoundConcave(float f, float f2, float f3) {
            super(f, f2, f3);
            this.c = f * f;
            this.d = Math.abs(f2 - f3) / f;
            this.e = f3 > f2;
            this.f = this.e ? f2 : f3;
        }

        final float a(float f) {
            if (this.e) {
                f = this.a - f;
            }
            return (float)Math.sqrt(this.c - f * f) * this.d + this.f;
        }
    }

    private static final class FlatZero
    extends Curve {
        private FlatZero(float f, float f2, float f3) {
            super(f, f2, f3);
        }

        final float a(float f) {
            return 0.0f;
        }
    }

    private static final class LinearStepped
    extends Curve {
        private final float c;
        private final float d;

        private LinearStepped(float f, float f2, float f3) {
            super(f, f2, f3);
            this.c = f3 / 5.0f;
            this.d = (f3 - f2) / 5.0f;
        }

        final float a(float f) {
            int n = (int)Math.ceil(f / this.c);
            return this.d * (float)n + this.b;
        }
    }

    private static final class Linear
    extends Curve {
        private final float c;

        private Linear(float f, float f2, float f3) {
            super(f, f2, f3);
            this.c = (f3 - f2) / f;
        }

        final float a(float f) {
            return this.c * f + this.b;
        }
    }
}

