/*
 * Decompiled with CFR 0.152.
 */
package djbo.hlpt;

import djbo.hlpt.Cols;
import djbo.hlpt.ImCanv;
import djbo.hlpt.ImFs;
import djbo.hlpt.MoreThan256Ex;
import djbo.hlpt.PntOperable;
import djbo.hlpt.PrecalcedPnt;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;

final class ImUtils {
    static final Color a = new Color(0, 0, 0, 0);
    static byte b = 0;
    static byte c = 1;
    static byte d = (byte)2;

    private ImUtils() {
    }

    private static boolean i(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        return n == 2 || n == 3 || n == 6 || n == 7;
    }

    static BufferedImage a(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    static BufferedImage b(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    private static BufferedImage a(int n, int n2, int n3) {
        return new BufferedImage(n, n2, n3);
    }

    static BufferedImage a(int n, int n2, Paint paint) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        if (paint != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    static BufferedImage a(int n, int n2, int n3, Color color) {
        BufferedImage bufferedImage = ImUtils.a(n, n2, n3);
        if (color != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(color);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    static BufferedImage a(Image image, int n, Paint paint) {
        if (!(image instanceof BufferedImage)) {
            new ImageIcon(image);
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = ImUtils.a(n2, n3, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, n2, n3);
        } else {
            graphics2D.setComposite(AlphaComposite.Src);
        }
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    static BufferedImage a(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 != null && bufferedImage2.getType() == bufferedImage.getType() && bufferedImage2.getWidth() == bufferedImage.getWidth() && bufferedImage2.getHeight() == bufferedImage.getHeight()) {
            bufferedImage2.setData(bufferedImage.getData());
        } else {
            bufferedImage2 = ImUtils.a(bufferedImage);
        }
        return bufferedImage2;
    }

    static BufferedImage a(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImUtils.a(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        bufferedImage2.setData(bufferedImage.getData());
        return bufferedImage2;
    }

    static BufferedImage a(Image image, int n) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == n) {
            bufferedImage = ImUtils.a((BufferedImage)image);
        } else {
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            bufferedImage = ImUtils.a(n2, n3, n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    static BufferedImage a(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        if (bufferedImage2 != null && bufferedImage2.getType() == bufferedImage.getType() && bufferedImage2.getType() == n && bufferedImage2.getWidth() == bufferedImage.getWidth() && bufferedImage2.getHeight() == bufferedImage.getHeight()) {
            bufferedImage2.setData(bufferedImage.getData());
        } else {
            bufferedImage2 = ImUtils.a((Image)bufferedImage, n);
        }
        return bufferedImage2;
    }

    static BufferedImage a(Image image, ImageObserver imageObserver) {
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        BufferedImage bufferedImage = ImUtils.b(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    static BufferedImage a(BufferedImage bufferedImage, Rectangle rectangle) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getType() == 0) {
            bufferedImage2 = ImUtils.b(rectangle.width, rectangle.height);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)bufferedImage, -rectangle.x, -rectangle.y, null);
            graphics2D.dispose();
        } else {
            int n = rectangle.width > 0 ? rectangle.width : 1;
            int n2 = rectangle.height > 0 ? rectangle.height : 1;
            BufferedImage bufferedImage3 = bufferedImage.getWidth() == n && bufferedImage.getHeight() == n2 && rectangle.x == 0 && rectangle.y == 0 ? bufferedImage : bufferedImage.getSubimage(rectangle.x, rectangle.y, n, n2);
            bufferedImage2 = ImUtils.a(rectangle.width, rectangle.height, bufferedImage.getType());
            bufferedImage2.setData(bufferedImage3.getData());
        }
        return bufferedImage2;
    }

    static BufferedImage b(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[]{1};
        int n3 = n2 - 1;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 12);
        WritableRaster writableRaster = bufferedImage2.getRaster();
        for (int i = n - 1; i >= 0; --i) {
            for (int j = n3; j >= 0; --j) {
                if (bufferedImage.getRGB(i, j) == 0) continue;
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage2;
    }

    static BufferedImage c(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 12);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage2;
    }

    static void a(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        if (bufferedImage2.getType() == 12 && bufferedImage.getTransparency() == 3) {
            Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            Rectangle rectangle2 = new Rectangle(n, n2, bufferedImage2.getWidth(), bufferedImage2.getHeight());
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            WritableRaster writableRaster = bufferedImage2.getRaster();
            int n3 = rectangle3.width - 1;
            int n4 = rectangle3.height - 1;
            int n5 = rectangle3.x;
            int n6 = rectangle3.y;
            for (int i = n3; i >= n5; --i) {
                for (int j = n4; j >= n6; --j) {
                    if (writableRaster.getSample(i, j, 0) != 0) continue;
                    bufferedImage.setRGB(i, j, 0);
                }
            }
        }
    }

    static void b(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2.getTransparency() == 3 && bufferedImage.getTransparency() == 3) {
            if (bufferedImage.getWidth() != bufferedImage2.getWidth() || bufferedImage.getHeight() != bufferedImage2.getHeight()) {
                throw new IllegalArgumentException("Sizes different");
            }
            int n = bufferedImage.getWidth() - 1;
            int n2 = bufferedImage.getHeight() - 1;
            for (int i = n; i >= 0; --i) {
                for (int j = n2; j >= 0; --j) {
                    int n3 = bufferedImage2.getRGB(i, j);
                    if (n3 == 0) {
                        bufferedImage.setRGB(i, j, 0);
                        continue;
                    }
                    int n4 = n3 & 0xFF000000;
                    if (n4 == -16777216) continue;
                    int n5 = bufferedImage.getRGB(i, j);
                    bufferedImage.setRGB(i, j, n4 | n5 & 0xFFFFFF);
                }
            }
        }
    }

    static void b(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        if (bufferedImage2.getTransparency() == 3 && bufferedImage.getTransparency() == 3) {
            int n3 = bufferedImage.getWidth() - 1;
            int n4 = n + (bufferedImage2.getWidth() - 1);
            int n5 = bufferedImage.getHeight() - 1;
            int n6 = n2 + (bufferedImage2.getHeight() - 1);
            int n7 = n < 0 ? 0 : n;
            int n8 = n2 < 0 ? 0 : n2;
            int n9 = n3 < n4 ? n3 : n4;
            int n10 = n5 < n6 ? n5 : n6;
            for (int i = n7; i <= n9; ++i) {
                for (int j = n8; j <= n10; ++j) {
                    if (bufferedImage2.getRGB(i - n, j - n2) != 0) continue;
                    bufferedImage.setRGB(i, j, 0);
                }
            }
        }
    }

    static void a(BufferedImage bufferedImage, int[] nArray) {
        if (bufferedImage.getTransparency() == 3) {
            int n = bufferedImage.getWidth();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] != 0) continue;
                int n2 = i % n;
                int n3 = i / n;
                bufferedImage.setRGB(n2, n3, 0);
            }
        }
    }

    static int c(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        int n3;
        block7: {
            n3 = 0;
            if (bufferedImage.getTransparency() != 3) break block7;
            boolean bl = bufferedImage2.getType() == 12;
            boolean bl2 = bufferedImage2.getTransparency() == 3;
            if (bl2 || bl) {
                Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                Rectangle rectangle2 = new Rectangle(n, n2, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                Rectangle rectangle3 = rectangle.intersection(rectangle2);
                int n4 = rectangle3.x;
                int n5 = rectangle3.y;
                int n6 = rectangle3.x + rectangle3.width - 1;
                int n7 = rectangle3.y + rectangle3.height - 1;
                if (bl) {
                    WritableRaster writableRaster = bufferedImage2.getRaster();
                    for (int i = n6; i >= n4; --i) {
                        int n8 = i - n;
                        for (int j = n7; j >= n5; --j) {
                            if (writableRaster.getSample(n8, j - n2, 0) == 0) continue;
                            bufferedImage.setRGB(i, j, 0);
                            ++n3;
                        }
                    }
                } else {
                    for (int i = n6; i >= n4; --i) {
                        int n9 = i - n;
                        for (int j = n7; j >= n5; --j) {
                            if (bufferedImage2.getRGB(n9, j - n2) == 0) continue;
                            bufferedImage.setRGB(i, j, 0);
                            ++n3;
                        }
                    }
                }
            }
        }
        return n3;
    }

    static void a(BufferedImage bufferedImage, Graphics2D graphics2D, Shape shape, ImCanv imCanv) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = ImUtils.b(n, n2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        imCanv.a(graphics2D2);
        graphics2D2.fill(shape);
        graphics2D2.dispose();
        Composite composite = null;
        if (graphics2D == null) {
            graphics2D = bufferedImage.createGraphics();
        } else {
            composite = graphics2D.getComposite();
        }
        graphics2D.setComposite(AlphaComposite.DstIn);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        if (composite == null) {
            graphics2D.dispose();
            return;
        }
        graphics2D.setComposite(composite);
    }

    static TrimmedImageIncSection d(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        TrimmedImageIncSection trimmedImageIncSection;
        block23: {
            trimmedImageIncSection = new TrimmedImageIncSection();
            new TrimmedImageIncSection().a = bufferedImage;
            n7 = bufferedImage.getWidth();
            n6 = bufferedImage.getHeight();
            n5 = bufferedImage.getType();
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            if (n5 == 12) {
                int n8;
                int n9;
                WritableRaster writableRaster = bufferedImage.getRaster();
                block0: for (n9 = 0; n9 < n7; ++n9) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        if (writableRaster.getSample(n9, n8, 0) == 0) continue;
                        n4 = n9;
                        break block0;
                    }
                }
                block2: for (n9 = 0; n9 < n6; ++n9) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        if (writableRaster.getSample(n8, n9, 0) == 0) continue;
                        n3 = n9;
                        break block2;
                    }
                }
                block4: for (n9 = n7 - 1; n9 >= 0; --n9) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        if (writableRaster.getSample(n9, n8, 0) == 0) continue;
                        n2 = n9 - n4 + 1;
                        break block4;
                    }
                }
                for (n9 = n6 - 1; n9 >= 0; --n9) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        if (writableRaster.getSample(n8, n9, 0) == 0) continue;
                        n = n9 - n3 + 1;
                        break block23;
                    }
                }
            } else if (bufferedImage.getTransparency() == 3) {
                int n10;
                int n11;
                block8: for (n11 = 0; n11 < n7; ++n11) {
                    for (n10 = 0; n10 < n6; ++n10) {
                        if (bufferedImage.getRGB(n11, n10) == 0) continue;
                        n4 = n11;
                        break block8;
                    }
                }
                block10: for (n11 = 0; n11 < n6; ++n11) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        if (bufferedImage.getRGB(n10, n11) == 0) continue;
                        n3 = n11;
                        break block10;
                    }
                }
                block12: for (n11 = n7 - 1; n11 >= 0; --n11) {
                    for (n10 = 0; n10 < n6; ++n10) {
                        if (bufferedImage.getRGB(n11, n10) == 0) continue;
                        n2 = n11 - n4 + 1;
                        break block12;
                    }
                }
                for (n11 = n6 - 1; n11 >= 0; --n11) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        if (bufferedImage.getRGB(n10, n11) == 0) continue;
                        n = n11 - n3 + 1;
                        break block23;
                    }
                }
            } else {
                System.err.println("Cannot trim off unset pixels in image of type: " + n5);
                return trimmedImageIncSection;
            }
        }
        trimmedImageIncSection.b = new Rectangle(n4, n3, n2, n);
        if (trimmedImageIncSection.b.width == 0 || trimmedImageIncSection.b.height == 0) {
            trimmedImageIncSection.a = ImUtils.a(1, 1, n5, null);
            trimmedImageIncSection.b = new Rectangle(0, 0, 1, 1);
            trimmedImageIncSection.c = true;
        } else if (trimmedImageIncSection.b.width < n7 || trimmedImageIncSection.b.height < n6) {
            trimmedImageIncSection.a = ImUtils.a(bufferedImage, trimmedImageIncSection.b);
        }
        return trimmedImageIncSection;
    }

    static short[] a(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        return ImUtils.a(n2, n3, n, bufferedImage, 0, 0);
    }

    private static short[] a(int n, int n2, int n3, BufferedImage bufferedImage, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n * n2;
        short[] sArray = new short[n10];
        int n11 = n - 1;
        int n12 = n2 - 1;
        int n13 = bufferedImage.getWidth() - 1;
        int n14 = bufferedImage.getHeight() - 1;
        for (int i = n12; i >= 0; --i) {
            n9 = n * i;
            n8 = i + n5;
            for (n7 = n11; n7 >= 0; --n7) {
                n6 = n7 + n4;
                if (n6 < 0 || n8 < 0 || n6 > n13 || n8 > n14) {
                    sArray[n9 + n7] = -1;
                    continue;
                }
                if (bufferedImage.getRGB(n7 + n4, i + n5) != 0) continue;
                sArray[n9 + n7] = -1;
            }
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n9 = n12; n9 >= 0; --n9) {
            n8 = n * n9;
            for (n7 = n11; n7 >= 0; --n7) {
                n6 = n8 + n7;
                if (sArray[n6] != 0 || !(n7 == 0 || sArray[n6 - 1] == -1 || n7 == n11 || sArray[n6 + 1] == -1 || n9 == 0 || sArray[n6 - n] == -1 || n9 == n12 || sArray[n6 + n] == -1 || n7 > 0 && n9 > 0 && sArray[n6 - n - 1] == -1 || n7 < n11 && n9 > 0 && sArray[n6 - n + 1] == -1 || n7 > 0 && n9 < n12 && sArray[n6 + n - 1] == -1) && (n7 >= n11 || n9 >= n12 || sArray[n6 + n + 1] != -1)) continue;
                sArray[n6] = 1;
                linkedList.add(n6);
            }
        }
        if (!linkedList.isEmpty()) {
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            for (n8 = 2; n8 <= n3; ++n8) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    n6 = (Integer)iterator.next();
                    int n15 = n6 % n;
                    int n16 = n6 / n;
                    int n17 = n6 - 1;
                    if (n15 > 0 && sArray[n17] == 0) {
                        sArray[n17] = (short)n8;
                        linkedList2.add(n17);
                    }
                    int n18 = n6 + 1;
                    if (n15 < n11 && sArray[n18] == 0) {
                        sArray[n18] = (short)n8;
                        linkedList2.add(n18);
                    }
                    int n19 = n6 - n;
                    if (n16 > 0 && sArray[n19] == 0) {
                        sArray[n19] = (short)n8;
                        linkedList2.add(n19);
                    }
                    int n20 = n6 + n;
                    if (n16 < n12 && sArray[n20] == 0) {
                        sArray[n20] = (short)n8;
                        linkedList2.add(n20);
                    }
                    int n21 = n19 - 1;
                    if (n15 > 0 && n16 > 0 && sArray[n21] == 0) {
                        sArray[n21] = (short)n8;
                        linkedList2.add(n21);
                    }
                    int n22 = n19 + 1;
                    if (n15 < n11 && n16 > 0 && sArray[n22] == 0) {
                        sArray[n22] = (short)n8;
                        linkedList2.add(n22);
                    }
                    int n23 = n20 - 1;
                    if (n15 > 0 && n16 < n12 && sArray[n23] == 0) {
                        sArray[n23] = (short)n8;
                        linkedList2.add(n23);
                    }
                    int n24 = n20 + 1;
                    if (n15 >= n11 || n16 >= n12 || sArray[n24] != 0) continue;
                    sArray[n24] = (short)n8;
                    linkedList2.add(n24);
                }
                if (linkedList2.isEmpty()) break;
                linkedList = linkedList2;
                linkedList2 = new LinkedList();
            }
        }
        return sArray;
    }

    static BufferedImage a(BufferedImage bufferedImage, Color color, boolean bl) {
        BufferedImage bufferedImage2;
        if (bl) {
            bufferedImage2 = ImUtils.a((Image)bufferedImage, 1, (Paint)Color.white);
            PrecalcedPnt precalcedPnt = PrecalcedPnt.a(color, null);
            ImFs.a(bufferedImage2, 0, 0, precalcedPnt, false);
        } else {
            bufferedImage2 = ImUtils.a((Image)bufferedImage, 1, (Paint)color);
        }
        return bufferedImage2;
    }

    static BufferedImage a(int n, int n2, BufferedImage bufferedImage, int n3, int n4, Graphics2D[] graphics2DArray, boolean bl, float f, Paint paint, ImageObserver imageObserver) {
        BufferedImage bufferedImage2 = ImUtils.a(n, n2, bl ? 2 : 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, n, n2);
        }
        Composite composite = null;
        if (f < 1.0f) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        graphics2D.drawImage((Image)bufferedImage, n3, n4, imageObserver);
        if (graphics2DArray != null) {
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            graphics2DArray[0] = graphics2D;
        } else {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    static BufferedImage a(BufferedImage bufferedImage, Paint paint) {
        if (bufferedImage.getTransparency() != 1) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Composite composite = graphics2D.getComposite();
            Paint paint2 = graphics2D.getPaint();
            graphics2D.setComposite(AlphaComposite.DstOver);
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint2);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    static BufferedImage a(PntOperable pntOperable, BufferedImage bufferedImage, ImCanv imCanv) {
        BufferedImage bufferedImage2 = bufferedImage != null ? bufferedImage : pntOperable.c();
        BufferedImage bufferedImage3 = bufferedImage2;
        if (pntOperable == imCanv.e && ImUtils.e(bufferedImage2)) {
            bufferedImage3 = ImUtils.a(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)imCanv.c(), -pntOperable.h(), -pntOperable.i(), null);
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage3;
    }

    static int a(float f, float f2, BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = (int)Math.floor(f);
        int n6 = (int)Math.ceil(f);
        int n7 = (int)Math.floor(f2);
        int n8 = (int)Math.ceil(f2);
        float f3 = f - (float)n5;
        float f4 = f2 - (float)n7;
        int n9 = bufferedImage.getRGB(n5, n7);
        int n10 = bufferedImage.getRGB(n5, n8);
        int n11 = bufferedImage.getRGB(n6, n7);
        int n12 = bufferedImage.getRGB(n6, n8);
        if (n9 == 0 && n10 == 0 && n11 == 0 && n12 == 0) {
            return 0;
        }
        int n13 = n9 >> 16 & 0xFF;
        int n14 = n9 >> 8 & 0xFF;
        int n15 = n9 & 0xFF;
        int n16 = n10 >> 16 & 0xFF;
        int n17 = n10 >> 8 & 0xFF;
        int n18 = n10 & 0xFF;
        int n19 = n11 >> 16 & 0xFF;
        int n20 = n11 >> 8 & 0xFF;
        int n21 = n11 & 0xFF;
        int n22 = n12 >> 16 & 0xFF;
        int n23 = n12 >> 8 & 0xFF;
        int n24 = n12 & 0xFF;
        if (n9 == 0 || n10 == 0 || n11 == 0 || n12 == 0) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            if (n9 != 0) {
                n3 = 0 + n13;
                n2 = 0 + n14;
                n = 0 + n15;
                ++n4;
            }
            if (n10 != 0) {
                n3 += n16;
                n2 += n17;
                n += n18;
                ++n4;
            }
            if (n11 != 0) {
                n3 += n19;
                n2 += n20;
                n += n21;
                ++n4;
            }
            if (n12 != 0) {
                n3 += n22;
                n2 += n23;
                n += n24;
                ++n4;
            }
            if (n4 > 0) {
                n3 /= n4;
                n2 /= n4;
                n /= n4;
                if (n9 == 0) {
                    n13 = n3;
                    n14 = n2;
                    n15 = n;
                }
                if (n10 == 0) {
                    n16 = n3;
                    n17 = n2;
                    n18 = n;
                }
                if (n11 == 0) {
                    n19 = n3;
                    n20 = n2;
                    n21 = n;
                }
                if (n12 == 0) {
                    n22 = n3;
                    n23 = n2;
                    n24 = n;
                }
            }
        }
        n4 = Math.round((float)n13 + f3 * (float)(n19 - n13));
        n3 = Math.round((float)n14 + f3 * (float)(n20 - n14));
        n2 = Math.round((float)n15 + f3 * (float)(n21 - n15));
        n = Math.round((float)n16 + f3 * (float)(n22 - n16));
        int n25 = Math.round((float)n17 + f3 * (float)(n23 - n17));
        int n26 = Math.round((float)n18 + f3 * (float)(n24 - n18));
        int n27 = Math.round((float)n4 + f4 * (float)(n - n4));
        int n28 = Math.round((float)n3 + f4 * (float)(n25 - n3));
        int n29 = Math.round((float)n2 + f4 * (float)(n26 - n2));
        return 0xFF000000 | n27 << 16 | n28 << 8 | n29;
    }

    public static int a(float[] fArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (fArray[1] == 0.0f) {
            n3 = n4 = (int)(fArray[2] * 255.0f + 0.5f);
            n2 = n4;
        } else {
            float f = fArray[1];
            float f2 = fArray[2];
            float f3 = (fArray[0] - (float)Math.floor(fArray[0])) * 6.0f;
            float f4 = f3 - (float)Math.floor(f3);
            float f5 = f2 * (1.0f - f);
            float f6 = f2 * (1.0f - f * f4);
            float f7 = f2 * (1.0f - f * (1.0f - f4));
            switch ((int)f3) {
                case 0: {
                    n2 = (int)(f2 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    n4 = (int)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f2 * 255.0f + 0.5f);
                    n4 = (int)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n2 = (int)(f5 * 255.0f + 0.5f);
                    n3 = (int)(f2 * 255.0f + 0.5f);
                    n4 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n2 = (int)(f5 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    n4 = (int)(f2 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f5 * 255.0f + 0.5f);
                    n4 = (int)(f2 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n2 = (int)(f2 * 255.0f + 0.5f);
                    n3 = (int)(f5 * 255.0f + 0.5f);
                    n4 = (int)(f6 * 255.0f + 0.5f);
                }
            }
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    static float a(int n) {
        int n2;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 = n3 > n4 ? n3 : n4;
        if (n5 > n2) {
            n2 = n5;
        }
        return (float)n2 / 255.0f;
    }

    public static float b(int n) {
        int n2;
        int n3;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n3 = n4 > n5 ? n4 : n5;
        if (n6 > n3) {
            n3 = n6;
        }
        int n8 = n2 = n4 < n5 ? n4 : n5;
        if (n6 < n2) {
            n2 = n6;
        }
        float f = n3 != 0 ? (float)(n3 - n2) / (float)n3 : 0.0f;
        return f;
    }

    public static float c(int n) {
        float f;
        float f2;
        int n2;
        int n3;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n3 = n4 > n5 ? n4 : n5;
        if (n6 > n3) {
            n3 = n6;
        }
        int n8 = n2 = n4 < n5 ? n4 : n5;
        if (n6 < n2) {
            n2 = n6;
        }
        if ((f2 = n3 != 0 ? (float)(n3 - n2) / (float)n3 : 0.0f) == 0.0f) {
            f = 0.0f;
        } else {
            float f3;
            float f4 = (float)(n3 - n4) / (float)(n3 - n2);
            float f5 = (float)(n3 - n5) / (float)(n3 - n2);
            float f6 = (float)(n3 - n6) / (float)(n3 - n2);
            f = n4 == n3 ? f6 - f5 : (n5 == n3 ? 2.0f + f4 - f6 : 4.0f + f5 - f4);
            f /= 6.0f;
            if (f3 < 0.0f) {
                f += 1.0f;
            }
        }
        return f;
    }

    static void a(int n, float[] fArray) {
        float f;
        float f2;
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        float f3 = (float)n2 / 255.0f;
        float f4 = (float)n3 / 255.0f;
        float f5 = (float)n4 / 255.0f;
        float f6 = Math.max(f3, Math.max(f4, f5));
        float f7 = Math.min(f3, Math.min(f4, f5));
        float f8 = f6 - f7;
        fArray[2] = f2 = (f6 + f7) * 0.5f;
        if (0.0f < f2 && f2 < 1.0f) {
            f = f2 <= 0.5f ? f2 : 1.0f - f2;
            fArray[1] = 0.5f * f8 / f;
        } else {
            fArray[1] = 0.0f;
        }
        if (f6 > 0.0f && f8 > 0.0f) {
            f = (f6 - f3) / f8;
            float f9 = (f6 - f4) / f8;
            float f10 = (f6 - f5) / f8;
            float f11 = f3 == f6 ? f10 - f9 : (f4 == f6 ? f - f10 + 2.0f : f9 - f + 4.0f);
            if (f11 < 0.0f) {
                f11 += 6.0f;
            }
            fArray[0] = f11 / 6.0f;
            return;
        }
        fArray[0] = 0.0f;
    }

    static float d(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        float f = (float)n2 / 255.0f;
        float f2 = (float)n3 / 255.0f;
        float f3 = (float)n4 / 255.0f;
        float f4 = Math.max(f, Math.max(f2, f3));
        float f5 = Math.min(f, Math.min(f2, f3));
        return (f4 + f5) * 0.5f;
    }

    static int b(float[] fArray, int n) {
        int n2;
        float f = fArray[2];
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (!(f <= 0.0f)) {
            if (f >= 1.0f) {
                f4 = 1.0f;
                f3 = 1.0f;
                f2 = 1.0f;
            } else {
                float f5 = 6.0f * fArray[0] % 6.0f;
                n2 = (int)f5;
                float f6 = f5 - (float)n2;
                float f7 = f <= 0.5f ? fArray[1] * f : fArray[1] * (1.0f - f);
                float f8 = f + f7;
                float f9 = f - f7;
                float f10 = (f8 - f9) * f6;
                float f11 = f8 - f10;
                float f12 = f9 + f10;
                switch (n2) {
                    case 0: {
                        f2 = f8;
                        f3 = f12;
                        f4 = f9;
                        break;
                    }
                    case 1: {
                        f2 = f11;
                        f3 = f8;
                        f4 = f9;
                        break;
                    }
                    case 2: {
                        f2 = f9;
                        f3 = f8;
                        f4 = f12;
                        break;
                    }
                    case 3: {
                        f2 = f9;
                        f3 = f11;
                        f4 = f8;
                        break;
                    }
                    case 4: {
                        f2 = f12;
                        f3 = f9;
                        f4 = f8;
                        break;
                    }
                    case 5: {
                        f2 = f8;
                        f3 = f9;
                        f4 = f11;
                    }
                }
            }
        }
        int n3 = (int)(f2 * 255.0f + 0.5f);
        n2 = (int)(f3 * 255.0f + 0.5f);
        int n4 = (int)(f4 * 255.0f + 0.5f);
        return n << 24 | n3 << 16 | n2 << 8 | n4;
    }

    private static void a(float[] fArray) {
        for (int i = 0; i < 3; ++i) {
            fArray[i] = fArray[i] > 0.03928f ? (float)Math.pow(((double)fArray[i] + 0.055) / 1.055, 2.4) : fArray[i] / 12.92f;
        }
    }

    static final void b(int n, float[] fArray) {
        float[] fArray2 = new float[3];
        float[] fArray3 = fArray2;
        fArray2[0] = (float)(n >> 16 & 0xFF) / 255.0f;
        fArray3[1] = (float)(n >> 8 & 0xFF) / 255.0f;
        fArray3[2] = (float)(n & 0xFF) / 255.0f;
        ImUtils.a(fArray3);
        float f = 0.4360747f * fArray3[0] + 0.3850649f * fArray3[1] + 0.1430804f * fArray3[2];
        float f2 = 0.2225045f * fArray3[0] + 0.7168786f * fArray3[1] + 0.0606169f * fArray3[2];
        float f3 = 0.0139322f * fArray3[0] + 0.0971045f * fArray3[1] + 0.7141733f * fArray3[2];
        float f4 = f + 15.0f * f2 + 3.0f * f3;
        fArray[0] = 4.0f * f / f4;
        fArray[1] = 6.0f * f2 / f4;
    }

    static Image a(BufferedImage bufferedImage, Component component) throws MoreThan256Ex {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = new int[256];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5 = bufferedImage.getRGB(i, j);
                n5 = 0xFF000000 | n5 & 0xFFFFFF;
                for (n = 0; n < n4 && nArray2[n] != n5; ++n) {
                }
                if (n > 255) {
                    throw new MoreThan256Ex("Too many colors.");
                }
                nArray[j * n2 + i] = n;
                if (n != n4) continue;
                nArray2[n] = n5;
                ++n4;
            }
        }
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        for (n = 0; n < n4; ++n) {
            byArray[n] = (byte)(nArray2[n] >> 16 & 0xFF);
            byArray2[n] = (byte)(nArray2[n] >> 8 & 0xFF);
            byArray3[n] = (byte)(nArray2[n] & 0xFF);
        }
        return component.createImage(new MemoryImageSource(n2, n3, (ColorModel)new IndexColorModel(8, n4, byArray, byArray2, byArray3), nArray, 0, n2));
    }

    static boolean a(Rectangle rectangle, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (rectangle != null) {
            n6 = rectangle.x;
            n5 = rectangle.y;
            n4 = n6 + rectangle.width - 1;
            n3 = n5 + rectangle.height - 1;
        } else {
            n6 = 0;
            n5 = 0;
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        }
        int n7 = (n6 + n4) / 2;
        int n8 = (n5 + n3) / 2;
        int n9 = 1;
        int n10 = 1;
        int n11 = n8;
        do {
            n2 = 1;
            n = 1;
            int n12 = n7;
            do {
                if (bufferedImage.getRGB(n12, n11) == bufferedImage2.getRGB(n12, n11)) continue;
                return true;
            } while ((n12 += 10 * ++n2 * (n *= -1)) >= n6 && n12 <= n4);
        } while ((n11 += 10 * ++n9 * (n10 *= -1)) >= n5 && n11 <= n3);
        for (n2 = n4; n2 >= n6; --n2) {
            for (n = n3; n >= n5; --n) {
                if (bufferedImage.getRGB(n2, n) == bufferedImage2.getRGB(n2, n)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean e(BufferedImage bufferedImage) {
        if (bufferedImage.getTransparency() == 1) {
            return false;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = n - 1;
        int n4 = n2 - 1;
        if (ImUtils.i(bufferedImage)) {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    if (writableRaster.getSample(i, j, 3) >= 255) continue;
                    return true;
                }
            }
        } else {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    int n5 = bufferedImage.getRGB(i, j);
                    int n6 = n5 >> 24 & 0xFF;
                    if (n6 >= 255) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean f(BufferedImage bufferedImage) {
        if (bufferedImage.getTransparency() == 1) {
            return false;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = n - 1;
        int n4 = n2 - 1;
        if (ImUtils.i(bufferedImage)) {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    if (writableRaster.getSample(i, j, 3) != 0) continue;
                    return true;
                }
            }
        } else {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    int n5 = bufferedImage.getRGB(i, j);
                    int n6 = n5 >> 24 & 0xFF;
                    if (n6 != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean g(BufferedImage bufferedImage) {
        if (bufferedImage.getTransparency() == 1) {
            return false;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = n - 1;
        int n4 = n2 - 1;
        if (ImUtils.i(bufferedImage)) {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    if (writableRaster.getSample(i, j, 3) == 0) continue;
                    return false;
                }
            }
        } else {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    int n5 = bufferedImage.getRGB(i, j);
                    if ((n5 & 0xFF000000) == 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    static byte h(BufferedImage bufferedImage) {
        if (bufferedImage.getTransparency() == 1) {
            return b;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = n - 1;
        int n4 = n2 - 1;
        boolean bl = false;
        if (ImUtils.i(bufferedImage)) {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    int n5 = writableRaster.getSample(i, j, 3);
                    if (n5 == 0) {
                        bl = true;
                        continue;
                    }
                    if (n5 == 255) continue;
                    return d;
                }
            }
        } else {
            for (int i = n3; i >= 0; --i) {
                for (int j = n4; j >= 0; --j) {
                    int n6 = bufferedImage.getRGB(i, j);
                    int n7 = n6 >> 24 & 0xFF;
                    if (n7 == 0) {
                        bl = true;
                        continue;
                    }
                    if (n7 == 255) continue;
                    return d;
                }
            }
        }
        if (bl) {
            return c;
        }
        return b;
    }

    static byte b(Image image, ImageObserver imageObserver) {
        if (image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() == 1) {
            return b;
        }
        if (image instanceof BufferedImage) {
            return ImUtils.h((BufferedImage)image);
        }
        return ImUtils.h(ImUtils.a(image, imageObserver));
    }

    static BufferedImage a(BufferedImageOp bufferedImageOp, BufferedImage bufferedImage, Shape shape, PrecalcedPnt precalcedPnt, ImCanv imCanv) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        BufferedImage bufferedImage3 = ImUtils.a(bufferedImage.getWidth(), bufferedImage.getHeight(), (Paint)Color.white);
        BufferedImage bufferedImage4 = bufferedImageOp.filter(bufferedImage3, null);
        if (shape != null) {
            ImUtils.a(bufferedImage2, null, shape, imCanv);
            ImUtils.a(bufferedImage4, null, shape, imCanv);
        }
        int n = bufferedImage4.getWidth();
        int n2 = bufferedImage4.getHeight();
        for (int i = n - 1; i >= 0; --i) {
            for (int j = n2 - 1; j >= 0; --j) {
                int n3 = bufferedImage4.getRGB(i, j);
                int n4 = n3 & 0xFF000000;
                if (n4 == -16777216) continue;
                if (precalcedPnt.e) {
                    precalcedPnt.a(i, j);
                }
                if (n4 == 0) {
                    bufferedImage2.setRGB(i, j, precalcedPnt.b);
                    continue;
                }
                int n5 = bufferedImage2.getRGB(i, j);
                bufferedImage2.setRGB(i, j, Cols.c(precalcedPnt.b, n5));
            }
        }
        return bufferedImage2;
    }

    static BufferedImage a(BufferedImage bufferedImage, boolean bl, boolean bl2) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(bl ? -1.0 : 1.0, bl2 ? -1.0 : 1.0);
        affineTransform.translate(bl ? (double)(-bufferedImage.getWidth()) : 0.0, bl2 ? (double)(-bufferedImage.getHeight()) : 0.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        return affineTransformOp.filter(bufferedImage, null);
    }

    static BufferedImage b(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        double d = Math.PI * 2 * (double)n / 360.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n == 90) {
            d2 = d3 = (double)n3 * 0.5;
        } else if (n == 180) {
            d2 = (double)n2 * 0.5;
            d3 = (double)n3 * 0.5;
        } else if (n == 270) {
            d2 = d3 = (double)n2 * 0.5;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        return affineTransformOp.filter(bufferedImage, null);
    }

    static BufferedImage c(BufferedImage bufferedImage, int n) {
        if (bufferedImage.getTransparency() == 3) {
            n |= 0xFF000000;
            bufferedImage = ImUtils.a(bufferedImage);
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n4 = bufferedImage.getRGB(j, i);
                    int n5 = n4 >> 24 & 0xFF;
                    if (n5 == 0 || n5 == 255) continue;
                    if (n5 < 128) {
                        bufferedImage.setRGB(j, i, n4 & 0xFFFFFF);
                        continue;
                    }
                    bufferedImage.setRGB(j, i, Cols.c(n, n4));
                }
            }
        }
        return bufferedImage;
    }

    static class TrimmedImageIncSection {
        BufferedImage a;
        Rectangle b;
        boolean c;

        TrimmedImageIncSection() {
        }
    }
}

